export function sitPet(e, entityTypes, yOffset, maxDistance) {
    const { player, block, dimension } = e;
    const petBedEntity = dimension.getEntitiesAtBlockLocation(block.location)
        .find(entity => entity.typeId === "drop:pet_bed_entity_drop");

    if (petBedEntity) {
        if (player.isSneaking) {
            petBedEntity.triggerEvent("drop:despawn");
        }
        return;
    }

    const newPetBedEntity = dimension.spawnEntity("drop:pet_bed_entity_drop", {
        x: block.x + 0.5,
        y: block.y + yOffset,
        z: block.z + 0.5
    });

    const petList = dimension.getEntities({
        location: { x: block.x + 0.5, y: block.y + 0.5, z: block.z + 0.5 },
        maxDistance: maxDistance
    });

    for (const entity of petList) {
        if (entityTypes.includes(entity.typeId)) {
            const leash = entity.getComponent("leashable");
            const isSitting = dimension.getEntitiesAtBlockLocation(entity.location).some(nearbyEntity => nearbyEntity.typeId === "drop:pet_bed_entity_drop");

            if (isSitting) continue;

            if (leash?.isLeashed && leash.leashHolder.typeId === "minecraft:player" && leash.leashHolder.name === player.name) {
                newPetBedEntity.getComponent("rideable").addRider(entity);

                const directionMap = {
                    south: 180,
                    west: -90,
                    east: 90
                };
                const rotation = directionMap[block.permutation.getState("minecraft:cardinal_direction")] || 0;
                newPetBedEntity.setRotation({ x: 0, y: rotation });
                leash.unleash();
                break;
            }
        }
    }
};